<?php

namespace App\Modules\HR\Entities;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Attachment extends Model 
{

    protected $table = 'attachments';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('file', 'type', 'employee_id');

    public function employees()
    {
        return $this->belongsTo('App\Modules\HR\Entities\Employee');
    }

}